<?php 
session_start();
if (!isset($_SESSION['SESS_ADMINLOGGEDIN'])) {
    header("Location: " . $config_basedir . "../admin/adminlogin.php");
    exit();
}

require_once("header.php");

// Fetch latest settings row
$stmt = $pdo->query("SELECT * FROM settings ORDER BY id DESC LIMIT 1");
$settings = $stmt->fetch(PDO::FETCH_ASSOC);
?>

<style>
/* General Panel Styling */
.control-panel {
  max-width: 600px;
  margin: auto;
  background: #0A0714;
  color: #fff;
  border-radius: 20px;
  padding: 25px;
  box-shadow: 0 8px 25px rgba(0,0,0,0.6);
}
.control-panel h1 {
  font-size: 26px;
  margin-bottom: 20px;
  text-align: center;
  color: #2FE6DE;
}

/* Section Cards */
.setting-card {
  background: #161223;
  padding: 20px;
  border-radius: 16px;
  margin-bottom: 20px;
  transition: all 0.3s ease-in-out;
}
.setting-card:hover {
  transform: translateY(-3px);
  box-shadow: 0 6px 15px rgba(47,230,222,0.3);
}

/* Toggle Switch */
.switch {
  position: relative;
  display: inline-block;
  width: 70px;
  height: 34px;
}
.switch input { display:none; }
.slider {
  position: absolute;
  cursor: pointer;
  top: 0; left: 0; right: 0; bottom: 0;
  background-color: #444;
  transition: .4s;
  border-radius: 34px;
}
.slider:before {
  position: absolute;
  content: "";
  height: 26px;
  width: 26px;
  left: 4px;
  bottom: 4px;
  background-color: #fff;
  transition: .4s;
  border-radius: 50%;
}
input:checked + .slider {
  background-color: #2FE6DE;
  box-shadow: 0 0 10px #2FE6DE;
}
input:checked + .slider:before {
  transform: translateX(36px);
}

/* Toast Notification */
.toast {
  position: fixed;
  bottom: 20px;
  right: 20px;
  background: #2FE6DE;
  color: #000;
  padding: 12px 18px;
  border-radius: 8px;
  font-weight: bold;
  display: none;
  z-index: 9999;
}
</style>

<div class="main-panel">
  <div class="content">
    <div class="page-inner">
      <div class="control-panel">
        <h1>⚙️ Admin Control Panel</h1>

        <?php if ($settings): ?>

          <!-- Email Verification -->
          <div class="setting-card">
            <h4>Email Verification</h4>
            <label class="switch">
              <input type="checkbox" data-setting="service2" <?php echo $settings['service2'] ? "checked" : ""; ?>>
              <span class="slider"></span>
            </label>
          </div>

          <!-- OTP Verification -->
          <div class="setting-card">
            <h4>OTP Verification</h4>
            <label class="switch">
              <input type="checkbox" data-setting="otp_status" <?php echo $settings['otp_status'] ? "checked" : ""; ?>>
              <span class="slider"></span>
            </label>
          </div>

          <!-- KYC2 Switch -->
          <div class="setting-card">
            <h4>KYC2 Verification</h4>
            <label class="switch">
              <input type="checkbox" data-setting="service3" <?php echo $settings['service3'] ? "checked" : ""; ?>>
              <span class="slider"></span>
            </label>
          </div>

          <!-- KYC3 Switch -->
          <div class="setting-card">
            <h4>KYC3 Verification</h4>
            <label class="switch">
              <input type="checkbox" data-setting="service4" <?php echo $settings['service4'] ? "checked" : ""; ?>>
              <span class="slider"></span>
            </label>
          </div>
          
          
          
           <!-- POPUP Switch -->
          <div class="setting-card">
            <h4>POPUP ALERT</h4>
            <label class="switch">
              <input type="checkbox" data-setting="service5" <?php echo $settings['service5'] ? "checked" : ""; ?>>
              <span class="slider"></span>
            </label>
          </div>

          <!-- Maintenance Mode -->
          <div class="setting-card">
            <h4>Maintenance Mode 🛠️</h4>
            <label class="switch">
              <input type="checkbox" data-setting="main_status" <?php echo $settings['main_status'] ? "checked" : ""; ?>>
              <span class="slider"></span>
            </label>
            
            
            <div class="form-group mt-3">
              <label>End Time</label>
              <input type="datetime-local" id="end_time" 
                value="<?php echo date('Y-m-d\TH:i', strtotime($settings['end_time'])); ?>" 
                class="form-control">
            </div>
          </div>

        <?php else: ?>
          <div class="alert alert-danger">⚠️ No settings found in database.</div>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>

<div id="toast" class="toast"></div>

<script>
// ✅ Show toast notification
function showToast(message) {
    let toast = document.getElementById("toast");
    toast.innerText = message;
    toast.style.display = "block";
    setTimeout(() => { toast.style.display = "none"; }, 3000);
}

// ✅ Auto-update on toggle
document.querySelectorAll("input[type=checkbox][data-setting]").forEach(el => {
    el.addEventListener("change", function() {
        let setting = this.getAttribute("data-setting");
        let value = this.checked ? 1 : 0;

        fetch("update_setting.php", {
            method: "POST",
            headers: { "Content-Type": "application/x-www-form-urlencoded" },
            body: "setting=" + setting + "&value=" + value
        })
        .then(res => res.text())
        .then(data => showToast(data));
    });
});

// ✅ Auto-update end_time
document.getElementById("end_time").addEventListener("change", function() {
    let value = this.value;
    fetch("update_setting.php", {
        method: "POST",
        headers: { "Content-Type": "application/x-www-form-urlencoded" },
        body: "setting=end_time&value=" + encodeURIComponent(value)
    })
    .then(res => res.text())
    .then(data => showToast(data));
});
</script>

<?php require("footer.php"); ?>
