<?php
session_start();
require("../config.php"); // PDO $pdo connection

// ===== Arrays for Symbols =====
$crypto = ['BTC','ETH','BNB','ADA','XRP','DOGE','DOT','SOL','LTC','LINK','UNI','MATIC','XLM','ATOM','VET','FIL','TRX','THETA','EOS','AAVE','AVAX','ALGO','ICP','KSM','NEO','CAKE','FTM','HNT','GRT','CRO','MKR','SUSHI','ZEC','BAT','ENJ','CHZ','1INCH','LRC','COMP','SNX','REN','NANO','CEL','OMG','YFI','KNC','DASH','QTUM','ICX','RSR','HIVE'];
$stocks = ['AAPL','MSFT','GOOGL','AMZN','TSLA','FB','NVDA','NFLX','ADBE','ORCL','INTC','CSCO','CRM','IBM','PYPL','SAP','UBER','TWTR','SQ','SHOP','BA','DIS','NKE','KO','PEP','MCD','BABA','V','MA','JNJ','WMT','PFE','CVX','XOM','COST','HD','PG','UNH','VZ','T','C','MMM','GS','JPM','BAC','CAT','RTX','DE','F','GM','GE','SPY'];
$commodities = ['XAU','XAG','OIL','NG','COFFEE','CORN','WHEAT','SOYBEAN','SUGAR','COTTON','PLAT','PALL','COPPER','ALUMINUM','LEAD','ZINC','NICKEL','TIN','URANIUM','RICE','BARLEY','OATS','RYE','CATTLE','HOGS','LUMBER','ETHANOL','SILVER','GOLD','PLATINUM','PALLADIUM','COCOA','COTTON2','COFFEE2','OIL2','NATGAS','GASOIL','PALM','SUGAR2','RICE2','CORN2','SOYBEAN2','WHEAT2','LME_COPPER','LME_ALUMINUM','LME_LEAD','LME_ZINC','LME_NICKEL'];
$forex = ['USD','EUR','JPY','GBP','AUD','CAD','CHF','NZD','CNY','HKD','SGD','INR','KRW','MXN','BRL','ZAR','RUB','TRY','SEK','NOK','DKK','PLN','ILS','PHP','MYR','THB','IDR','ARS','CLP','COP','EGP','SAR','AED','KWD','QAR','BHD','OMR','JOD','MAD','TWD','VND','PKR','LKR','BDT','NGN','KES','GHS','TZS','UGX','MUR','BWP'];

// ===== Handle Generate Icons =====
if (isset($_POST['generate_icons'])) {
    // Clear old pairs
    $pdo->exec("TRUNCATE TABLE pairs");

    $insert = $pdo->prepare("INSERT INTO pairs (symbol, base, quote, type, icon, status, created_at) VALUES (?, ?, ?, ?, ?, 1, NOW())");

    // Helper function for crypto icons
    function cryptoIcon($symbol) {
        return "https://cryptologos.cc/logos/".strtolower($symbol)."-".$symbol."-logo.png";
    }

    // Helper function for stock icons (Clearbit)
    function stockIcon($symbol) {
        return "https://logo.clearbit.com/".strtolower($symbol).".com";
    }

    // Helper function for forex icons (flags)
    function forexIcon($symbol) {
        $flags = [
            'USD'=>'https://upload.wikimedia.org/wikipedia/en/a/a4/Flag_of_the_United_States.svg',
            'EUR'=>'https://upload.wikimedia.org/wikipedia/commons/b/b7/Flag_of_Europe.svg',
            'JPY'=>'https://upload.wikimedia.org/wikipedia/en/9/9e/Flag_of_Japan.svg',
            'GBP'=>'https://upload.wikimedia.org/wikipedia/en/a/ae/Flag_of_the_United_Kingdom.svg',
            'AUD'=>'https://upload.wikimedia.org/wikipedia/commons/b/b9/Flag_of_Australia.svg',
            'CAD'=>'https://upload.wikimedia.org/wikipedia/commons/d/d9/Flag_of_Canada_(Pantone).svg',
            'CHF'=>'https://upload.wikimedia.org/wikipedia/commons/f/f3/Flag_of_Switzerland.svg',
            'NZD'=>'https://upload.wikimedia.org/wikipedia/commons/3/3e/Flag_of_New_Zealand.svg'
            // Add more if needed
        ];
        return $flags[$symbol] ?? 'https://via.placeholder.com/40';
    }

    // Helper function for commodities icons
    function commodityIcon($symbol) {
        return "https://upload.wikimedia.org/wikipedia/commons/thumb/3/3a/".strtoupper($symbol).".jpg/240px-".strtoupper($symbol).".jpg";
    }

    // Insert all cryptos
    foreach ($crypto as $symbol) {
        $insert->execute([$symbol."/USD",$symbol,'USD','crypto',cryptoIcon($symbol)]);
    }

    // Insert all stocks
    foreach ($stocks as $symbol) {
        $insert->execute([$symbol."/USD",$symbol,'USD','stock',stockIcon($symbol)]);
    }

    // Insert all commodities
    foreach ($commodities as $symbol) {
        $insert->execute([$symbol."/USD",$symbol,'USD','commodity',commodityIcon($symbol)]);
    }

    // Insert all forex
    foreach ($forex as $symbol) {
        $insert->execute([$symbol."/USD",$symbol,'USD','forex',forexIcon($symbol)]);
    }

    $msg = "All 200 symbols inserted with icons!";
}

// ===== Fetch all pairs =====
$pairsStmt = $pdo->query("SELECT * FROM pairs ORDER BY id ASC");
$pairsList = $pairsStmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Generate Icons for All Pairs</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<style>
    body { background:#0F0A1F; color:white; font-family:sans-serif; padding:20px; }
    table { width:100%; border-collapse:collapse; margin-top:20px; }
    th, td { padding:10px; border:1px solid #444; text-align:center; }
    img { width:40px; height:40px; object-fit:cover; border-radius:50%; }
    button { padding:10px 20px; background:#2FE6DE; border:none; color:black; font-weight:bold; cursor:pointer; border-radius:5px; }
    button:hover { filter:brightness(1.1); }
</style>
</head>
<body>

<h1>Pairs Table - Icon Generator (200 Symbols)</h1>

<?php if (!empty($msg)) echo "<p style='color:lime;'>$msg</p>"; ?>

<form method="POST">
    <button type="submit" name="generate_icons"><i class="fas fa-magic"></i> Generate All Icons</button>
</form>

<table>
    <thead>
        <tr>
            <th>ID</th>
            <th>Symbol</th>
            <th>Base</th>
            <th>Quote</th>
            <th>Type</th>
            <th>Icon</th>
            <th>Status</th>
            <th>Created At</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($pairsList as $pair): ?>
        <tr>
            <td><?= htmlspecialchars($pair['id']); ?></td>
            <td><?= htmlspecialchars($pair['symbol']); ?></td>
            <td><?= htmlspecialchars($pair['base']); ?></td>
            <td><?= htmlspecialchars($pair['quote']); ?></td>
            <td><?= htmlspecialchars($pair['type']); ?></td>
            <td>
                <?php if (!empty($pair['icon'])): ?>
                    <img src="<?= htmlspecialchars($pair['icon']); ?>" alt="<?= htmlspecialchars($pair['base']); ?>">
                <?php else: ?>
                    <i class="fas fa-question-circle"></i>
                <?php endif; ?>
            </td>
            <td><?= htmlspecialchars($pair['status']); ?></td>
            <td><?= htmlspecialchars($pair['created_at']); ?></td>
        </tr>
        <?php endforeach; ?>
    </tbody>
</table>

</body>
</html>
