<?php
require_once("header.php");

// Fetch all referral earnings from `ref` table
$stmt = $pdo->query("SELECT * FROM ref ORDER BY date DESC");
$referrals = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Fetch user referral stats from `logins` table
$stmt2 = $pdo->query("SELECT id, username, email, refid, refcom, reftot, refact FROM logins ORDER BY id DESC");
$users = $stmt2->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="main-panel">
  <div class="content bg-light">
    <div class="page-inner">

      <h2 class="mb-4">Referral Earnings Overview</h2>

      <!-- Referral Earnings Table -->
      <div class="table-responsive mb-5">
        <h4 class="mb-3">Referral Earnings (ref table)</h4>
        <table class="table table-striped table-bordered">
          <thead class="thead-dark">
            <tr>
              <th>ID</th>
              <th>UserID</th>
              <th>Username</th>
              <th>Email</th>
              <th>Phone</th>
              <th>Amount Earned</th>
              <th>Date</th>
            </tr>
          </thead>
          <tbody>
            <?php if ($referrals): ?>
              <?php foreach ($referrals as $row): ?>
                <tr>
                  <td><?= htmlspecialchars($row['id']) ?></td>
                  <td><?= htmlspecialchars($row['userid']) ?></td>
                  <td><?= htmlspecialchars($row['username']) ?></td>
                  <td><?= htmlspecialchars($row['email']) ?></td>
                  <td><?= htmlspecialchars($row['phone']) ?></td>
                  <td><strong>$<?= number_format($row['amount'], 2) ?></strong></td>
                  <td><?= htmlspecialchars($row['date']) ?></td>
                </tr>
              <?php endforeach; ?>
            <?php else: ?>
              <tr><td colspan="7" class="text-center">No referral earnings yet.</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>

      <!-- User Referral Stats -->
      <div class="table-responsive">
        <h4 class="mb-3">User Referral Stats (logins table)</h4>
        <table class="table table-striped table-bordered">
          <thead class="thead-dark">
            <tr>
              <th>User ID</th>
              <th>Username</th>
              <th>Email</th>
              <th>Referrer ID</th>
              <th>Total Bonus (refcom)</th>
              <th>Total Referrals (reftot)</th>
              <th>Successful Deposits (refact)</th>
            </tr>
          </thead>
          <tbody>
            <?php if ($users): ?>
              <?php foreach ($users as $user): ?>
                <tr>
                  <td><?= htmlspecialchars($user['id']) ?></td>
                  <td><?= htmlspecialchars($user['username']) ?></td>
                  <td><?= htmlspecialchars($user['email']) ?></td>
                  <td><?= htmlspecialchars($user['refid']) ?></td>
                  <td><strong>$<?= number_format($user['refcom'], 2) ?></strong></td>
                  <td><?= htmlspecialchars($user['reftot']) ?></td>
                  <td><?= htmlspecialchars($user['refact']) ?></td>
                </tr>
              <?php endforeach; ?>
            <?php else: ?>
              <tr><td colspan="7" class="text-center">No referral stats found.</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>

    </div>
  </div>
</div>

<?php require("footer.php"); ?>
