<?php 
session_start();
if (!isset($_SESSION['SESS_ADMINLOGGEDIN'])) {
    header("Location: " . $config_basedir . "../admin/adminlogin.php");
    exit();
}

require_once("header.php");

// Always fetch latest row
$stmt = $pdo->query("SELECT * FROM settings ORDER BY id DESC LIMIT 1");
$settings = $stmt->fetch(PDO::FETCH_ASSOC);
$id = $settings ? $settings['id'] : 0;

// Handle updates
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Email Verification
    if (isset($_POST['email_verification_action'])) {
        $status = isset($_POST['service2']) ? 1 : 0;
        $stmt = $pdo->prepare("UPDATE settings SET service2 = ? WHERE id = ?");
        $stmt->execute([$status, $id]);
        $msg = $status ? "Email Verification turned ON ✅" : "Email Verification turned OFF ❌";
        echo "<script>alert('$msg');window.location.href='admin_control.php';</script>";
    }

    // OTP
    if (isset($_POST['otp_action'])) {
        $status = isset($_POST['otp_status']) ? 1 : 0;
        $stmt = $pdo->prepare("UPDATE settings SET otp_status = ? WHERE id = ?");
        $stmt->execute([$status, $id]);
        $msg = $status ? "OTP turned ON ✅" : "OTP turned OFF ❌";
        echo "<script>alert('$msg');window.location.href='admin_control.php';</script>";
    }

    // Maintenance Mode
    if (isset($_POST['maintenance_action'])) {
        $status = isset($_POST['main_status']) ? 1 : 0;
        $end_time = $_POST['end_time'];
        $stmt = $pdo->prepare("UPDATE settings SET main_status = ?, end_time = ? WHERE id = ?");
        $stmt->execute([$status, $end_time, $id]);
        $msg = $status ? "Maintenance Mode turned ON 🛠️" : "Maintenance Mode turned OFF ✅";
        echo "<script>alert('$msg');window.location.href='admin_control.php';</script>";
    }
}
?>

<style>
/* Toggle Switch Style */
.switch {
  position: relative;
  display: inline-block;
  width: 70px;
  height: 34px;
}
.switch input {display:none;}
.slider {
  position: absolute;
  cursor: pointer;
  top: 0; left: 0; right: 0; bottom: 0;
  background-color: #ccc;
  transition: .4s;
  border-radius: 34px;
}
.slider:before {
  position: absolute;
  content: "";
  height: 26px;
  width: 26px;
  left: 4px;
  bottom: 4px;
  background-color: white;
  transition: .4s;
  border-radius: 50%;
}
input:checked + .slider {
  background-color: #2FE6DE;
  box-shadow: 0 0 10px #2FE6DE;
}
input:checked + .slider:before {
  transform: translateX(36px);
}
</style>

<div class="main-panel">
  <div class="content bg-light">
    <div class="page-inner">
      <div class="mt-2 mb-4 text-center">
        <h1 class="title1 text-dark">⚙️ ADMIN CONTROL PANEL</h1>
        <p class="text-muted">Manage system settings in real-time</p>
      </div>

      <?php if ($settings): ?>
      <div class="row mb-5">
        <div class="col-md-6 offset-md-3">

          <!-- EMAIL VERIFICATION -->
          <form method="POST" class="card p-4 mb-4 shadow-sm">
            <h4>Email Verification</h4>
            <label class="switch">
              <input type="checkbox" name="service2" <?php echo $settings['service2'] ? "checked" : ""; ?>>
              <span class="slider"></span>
            </label>
            <p class="mt-2">Current: 
              <strong style="color:<?php echo $settings['service2'] ? '#28a745' : 'red'; ?>">
                <?php echo $settings['service2'] ? "ON ✅" : "OFF ❌"; ?>
              </strong>
            </p>
            <button type="submit" name="email_verification_action" class="btn btn-success btn-block">Update</button>
          </form>

          <!-- OTP CONTROL -->
          <form method="POST" class="card p-4 mb-4 shadow-sm">
            <h4>OTP Verification</h4>
            <label class="switch">
              <input type="checkbox" name="otp_status" <?php echo $settings['otp_status'] ? "checked" : ""; ?>>
              <span class="slider"></span>
            </label>
            <p class="mt-2">Current: 
              <strong style="color:<?php echo $settings['otp_status'] ? '#28a745' : 'red'; ?>">
                <?php echo $settings['otp_status'] ? "ON ✅" : "OFF ❌"; ?>
              </strong>
            </p>
            <button type="submit" name="otp_action" class="btn btn-success btn-block">Update</button>
          </form>

          <!-- MAINTENANCE MODE -->
          <form method="POST" class="card p-4 mb-4 shadow-sm">
            <h4>Maintenance Mode 🛠️</h4>
            <label class="switch">
              <input type="checkbox" name="main_status" <?php echo $settings['main_status'] ? "checked" : ""; ?>>
              <span class="slider"></span>
            </label>
            <p class="mt-2">Current: 
              <strong style="color:<?php echo $settings['main_status'] ? '#ffc107' : '#28a745'; ?>">
                <?php echo $settings['main_status'] ? "ON 🛠️" : "OFF ✅"; ?>
              </strong>
            </p>
            <div class="form-group mt-3">
              <label>End Time</label>
              <input type="datetime-local" name="end_time" 
                value="<?php echo date('Y-m-d\TH:i', strtotime($settings['end_time'])); ?>" 
                class="form-control" required>
            </div>
            <button type="submit" name="maintenance_action" class="btn btn-warning btn-block">Update</button>
          </form>

        </div>
      </div>
      <?php else: ?>
        <div class="alert alert-danger">⚠️ No settings row found in database.</div>
      <?php endif; ?>
    </div>
  </div>
</div>

<?php require("footer.php"); ?>
