<?php 

require_once("header.php");
?>

<style>
    
.kyc-radio-group {
  display: flex;
  gap: 10px;
  justify-content: center;
  align-items: center;
}

.kyc-radio-group input[type="radio"] {
  display: none;
}

.kyc-option {
  padding: 8px 16px;
  border-radius: 8px;
  font-weight: bold;
  font-size: 14px;
  cursor: pointer;
  transition: all 0.3s ease;
  user-select: none;
  white-space: nowrap;
}

.kyc-option.KYC2 { background: #ff9800; color: #fff; }


.kyc-option.KYC3 { background: #2196f3; color: #fff; }



.kyc-option.CONFIRM { background: #2196f3; color: #fff; }


.kyc-option.DECLINE { background: #f44336; color: #fff; }




.kyc-radio-group input[type="radio"]:checked + .kyc-option {
  transform: scale(1.1);
  box-shadow: 0 4px 12px rgba(0,0,0,0.3);
  font-size: 33px;
}

.kyc-option:active {
  transform: scale(5);
}

@media (max-width: 600px) {
  .kyc-option {
    padding: 6px 10px;
    font-size: 12px;
  }
}


</style>
   


   
   <?php


// Fetch the login records
$query = "SELECT * FROM logins WHERE ip > 0";

// $ordersStmt = $pdo->query("SELECT * FROM logins WHERE ip > 0 ");

$stmt = $pdo->query($query);
$users = $stmt->fetchAll(PDO::FETCH_ASSOC);


?>

<div class="main-panel bg-light">
    <div class="content bg-light">
        <div class="page-inner">
            <div class="mt-2 mb-4">
                <h1 class="title1 text-dark"><?php echo $domain_name ?> account verification list</h1>
            </div>

           

            <input type="text" id="myInput" onkeyup="myFunction()" placeholder="Search for names.." title="Type in a name" class="table table-striped table-bordered">
            
            <div class="table-responsive" data-example-id="hoverable-table">
                <table id="myTable" class="table table-hover text-dark">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>User name</th>
                            <th>Full name</th>
                            <th>Email</th>
                            <th>KYC 2/3 Status</th>
                            <th>F/B ID CARD</th>
                            <th>Address</th>
                            <th>ACTIONs</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($users as $row) : ?>
                            <tr>
                                <th scope="row"><?php echo $row['id']; ?></th>
                                <td><?php echo $row['username']; ?></td>
                                <td><?php echo $row['fullname']; ?></td>
                                <td><a href="mailto:<?php echo $row['email']; ?>" class="__cf_email__"><?php echo $row['email']; ?></a></td>
                                <td>
                                    <?php
                                    if ($row['verified'] == 0) {
                                        echo "<span class='badge badge-link'>NO DOCUMENT</span>";
                                    } 
                                    
                                   
                                    elseif ($row['verified'] == 1) {
                                        echo "<span class='badge badge-warning'>KYC1 UNDER REVIEW</span>";
                                    } 
                                    
                                    
                                    
                                     elseif ($row['verified'] == 2) {
                                        echo "<span class='badge badge-warning'>KYC2 UNDER REVIEW</span>";
                                    } 
                                    
                                  
                                    elseif ($row['verified'] == 3) {
                                        echo "<span class='badge badge-success'>VERIFIED</span>";
                                    }
                                    ?>
                                </td>
                                <td>
                                    <a href="admin_vfcard.php?id=<?php echo $row['id']; ?>" class="btn btn-blue btn-sm"><i class="fa fa-eye"></i> FRONT</a>
                                    <a href="admin_vbcard.php?id=<?php echo $row['id']; ?>" class="btn btn-blue btn-sm"><i class="fa fa-eye"></i> BACK</a>
                                </td>
                                
                                <td>
                                    <a href="admin_view_address.php?id=<?php echo $row['id']; ?>" class="btn btn-dark btn-sm"><i class="fa fa-eye"></i> ADDRESS</a>
                                </td>
                                
                               
                               <td>
  <div class="kyc-radio-group" data-userid="<?php echo $row['id']; ?>">
   

   <input type="radio" id="DECLINE_<?php echo $row['id']; ?>" 
           name="verified_<?php echo $row['id']; ?>" value="0"
           <?php echo $row['verified'] == 0 ? 'checked' : ''; ?>>
    <label for="DECLINE_<?php echo $row['id']; ?>" class="kyc-option DECLINE">DECLINE</label>
    

    <input type="radio" id="CONFIRM_<?php echo $row['id']; ?>" 
           name="verified_<?php echo $row['id']; ?>" value="3"
           <?php echo $row['verified'] == 3 ? 'checked' : ''; ?>>
    <label for="CONFIRM_<?php echo $row['id']; ?>" class="kyc-option CONFIRM">CONFIRM</label>
    

    
    
    
  
    
    
  </div>
</td>




                                
                                
                           

                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>



				     	</div>
					</div>
			</div> 
						
					
			
			
			
			
			
			
			
									





									
								
																			
			<script>
document.querySelectorAll(".kyc-radio-group input[type='radio']").forEach(radio => {
  radio.addEventListener("change", function() {
    let userId = this.closest(".kyc-radio-group").dataset.userid;
    let value = this.value;

    fetch("update_verified.php", {
      method: "POST",
      headers: { "Content-Type": "application/x-www-form-urlencoded" },
      body: "id=" + userId + "&verified=" + value
    })
    .then(res => res.text())
    .then(data => {
      // Success popup
      let alertBox = document.createElement("div");
      alertBox.innerText = "✅ Verification updated!";
      alertBox.style.position = "fixed";
      alertBox.style.top = "20px";
      alertBox.style.right = "20px";
      alertBox.style.background = "#4caf50";
      alertBox.style.color = "#fff";
      alertBox.style.padding = "12px 20px";
      alertBox.style.borderRadius = "8px";
      alertBox.style.boxShadow = "0 4px 12px rgba(0,0,0,0.3)";
      alertBox.style.zIndex = "9999";
      alertBox.style.fontWeight = "bold";
      alertBox.style.transition = "opacity 0.5s ease";
      document.body.appendChild(alertBox);

      setTimeout(() => {
        alertBox.style.opacity = "0";
        setTimeout(() => alertBox.remove(), 500);
      }, 2000);
    })
    .catch(err => console.error("Error:", err));
  });
});

</script>


			
			
			            

<?php require ("footer.php")  ?>