<?php
require_once("header.php");

// Handle toggle switch action
if (isset($_GET['toggle_id'])) {
    $id = intval($_GET['toggle_id']);
    $stmt = $pdo->prepare("SELECT switch FROM logins WHERE id = ?");
    $stmt->execute([$id]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($row) {
        $newSwitch = ($row['switch'] == 1) ? 0 : 1;
        $stmtUpdate = $pdo->prepare("UPDATE logins SET switch = ? WHERE id = ?");
        $stmtUpdate->execute([$newSwitch, $id]);
    }

    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

// Handle deletion
if (isset($_GET['del'])) {
    $idToDelete = intval($_GET['del']);
    $stmtDel = $pdo->prepare("DELETE FROM logins WHERE id = ?");
    $stmtDel->execute([$idToDelete]);
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

// Fetch all users
$stmt = $pdo->query("SELECT * FROM logins WHERE ip > 0 ORDER BY id DESC");
$users = $stmt->fetchAll();
?>

<main class="flex-1 px-4 py-6 bg-[#0B0A13] min-h-screen text-white">
    <div class="max-w-7xl mx-auto">
        <h1 class="text-3xl font-bold mb-6">Lock Profit Management</h1>

        <!-- Search -->
        <input type="text" id="searchInput" placeholder="Search users..." 
               class="w-full mb-6 p-3 rounded-xl bg-[#1C1A2E] text-white focus:outline-none focus:ring-2 focus:ring-[#2FE6DE]">

        <div class="overflow-x-auto rounded-2xl bg-[#141222]">
            <table class="min-w-full text-white table-auto">
                <thead class="bg-[#1C1A2E] text-left">
                    <tr>
                        <th class="px-4 py-3">ID</th>
                        <th class="px-4 py-3">Client Name</th>
                        <th class="px-4 py-3">Username</th>
                        <th class="px-4 py-3">Balance</th>
                        <th class="px-4 py-3">Capital</th>
                        <th class="px-4 py-3">Email</th>
                        <th class="px-4 py-3">Phone</th>
                        <th class="px-4 py-3">Lock Profit</th>
                        <th class="px-4 py-3">Actions</th>
                    </tr>
                </thead>
                <tbody id="usersTable">
                    <?php foreach ($users as $user): ?>
                        <tr class="border-b border-gray-700 hover:bg-[#1F1D2B]">
                            <td class="px-4 py-3"><?= $user['id'] ?></td>
                            <td class="px-4 py-3"><?= htmlspecialchars($user['fullname']) ?></td>
                            <td class="px-4 py-3"><?= htmlspecialchars($user['username']) ?></td>
                            <td class="px-4 py-3">&#36;<?= $user['balance'] ?></td>
                            <td class="px-4 py-3">&#36;<?= $user['ibalance'] ?></td>
                            <td class="px-4 py-3"><a href="mailto:<?= htmlspecialchars($user['email']) ?>" class="text-blue-400"><?= htmlspecialchars($user['email']) ?></a></td>
                            <td class="px-4 py-3"><?= $user['phone'] ?></td>
                            <td class="px-4 py-3">
                                <?php if($user['switch'] == 1): ?>
                                    <a href="?toggle_id=<?= $user['id'] ?>" class="px-3 py-1 rounded-lg bg-green-600 font-semibold hover:bg-green-500 transition">OPEN</a>
                                <?php else: ?>
                                    <a href="?toggle_id=<?= $user['id'] ?>" class="px-3 py-1 rounded-lg bg-gray-600 font-semibold hover:bg-gray-500 transition">LOCK</a>
                                <?php endif; ?>
                            </td>
                            <td class="px-4 py-3 space-x-2">
                                <a href="userdatails.php?id=<?= $user['id'] ?>" class="px-3 py-1 rounded-lg bg-blue-600 hover:bg-blue-500 font-semibold transition">Details</a>
                                <button onclick="confirmDelete(<?= $user['id'] ?>)" class="px-3 py-1 rounded-lg bg-red-600 hover:bg-red-500 font-semibold transition">DEL</button>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</main>

<!-- Delete Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content bg-[#1C1A2E] text-white">
      <div class="modal-header">
        <h5 class="modal-title">Confirm Deletion</h5>
        <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
      </div>
      <div class="modal-body">
        Are you sure you want to delete this user? This action cannot be undone.
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
        <button type="button" id="confirmDeleteBtn" class="btn btn-danger">Delete</button>
      </div>
    </div>
  </div>
</div>

<script>
// Delete confirmation
let deleteId = null;
function confirmDelete(id) {
    deleteId = id;
    $('#deleteModal').modal('show');
}
document.getElementById('confirmDeleteBtn').addEventListener('click', function () {
    if (deleteId !== null) {
        window.location.href = 'adminverify.php?del=' + deleteId;
    }
});

// Search/filter users
document.getElementById('searchInput').addEventListener('keyup', function() {
    const filter = this.value.toLowerCase();
    const rows = document.querySelectorAll('#usersTable tr');
    rows.forEach(row => {
        row.style.display = row.textContent.toLowerCase().includes(filter) ? '' : 'none';
    });
});
</script>

<?php require("footer.php"); ?>
