<?php 
session_start();
if (!isset($_SESSION['SESS_ADMINLOGGEDIN'])) {
    header("Location: " . $config_basedir . "../admin/adminlogin.php");
    exit();
}

require_once("header.php");
require_once("../config.php"); // ensure DB connection file

// ---------------- DELETE REVIEW ----------------
if (isset($_GET['del']) && is_numeric($_GET['del'])) {
    $del_id = (int) $_GET['del'];

    $stmt = $pdo->prepare("DELETE FROM review WHERE id = :id");
    $stmt->execute([':id' => $del_id]);

    echo "<span style='color:red'>Successfully deleted.
        <meta http-equiv='refresh' content='2; url=reviews.php'/>
    </span>";
}
?>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

<style>
    .button-group {
      display: flex;
      justify-content: center;
      align-items: center;
      gap: 10px;
    }
    .button-group button {
      padding: 10px 20px;
      font-size: 16px;
      border: 1px solid #ccc;
      border-radius: 5px;
      background-color: #f5f5f5;
      cursor: pointer;
      transition: background-color 0.3s ease;
    }
    .button-group button:hover {
      background-color: #ddd;
    }
    .button-group button:active {
      background-color: #bbb;
    }
</style>

<?php
// ---------------- ADD REVIEW ----------------
if (isset($_POST['add_review'])) {
    $name = htmlspecialchars($_POST['name']);
    $position = htmlspecialchars($_POST['position']);
    $note = htmlspecialchars($_POST['note']);
    $status = (int) $_POST['status'];

    $maxsize = 104857600; // 100MB
    $uploadOk = false;
    $Pack_location2 = "";

    if (!empty($_FILES['imgfile2']['name'])) {
        $target_dir = "../accounts/upload/review/";
        $filename = basename($_FILES["imgfile2"]["name"]);
        $target_file = $target_dir . $filename;
        $extension = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));
        $extensions_arr = ["jpg", "png", "jpeg", "gif", "jfif"];

        if (in_array($extension, $extensions_arr)) {
            if ($_FILES['imgfile2']['size'] > 0 && $_FILES['imgfile2']['size'] < $maxsize) {
                if (move_uploaded_file($_FILES["imgfile2"]["tmp_name"], $target_file)) {
                    $Pack_location2 = "accounts/upload/review/" . $filename;
                    $uploadOk = true;
                }
            } else {
                echo "<div class='alert alert-danger'>File too large or empty. Max 100MB.</div>";
            }
        } else {
            echo "<div class='alert alert-danger'>Invalid file type.</div>";
        }
    }

    if ($uploadOk) {
        try {
            $stmt = $pdo->prepare("INSERT INTO review (name, position, Pack_location, status, note) 
                                   VALUES (:name, :position, :Pack_location, :status, :note)");
            $stmt->execute([
                ':name' => $name,
                ':position' => $position,
                ':Pack_location' => $Pack_location2,
                ':status' => $status,
                ':note' => $note
            ]);

            echo "<script>
                    alert('Review uploaded successfully!');
                    window.location.href = 'reviews.php';
                  </script>";
        } catch (PDOException $e) {
            echo "<div class='alert alert-danger'>Error: " . $e->getMessage() . "</div>";
        }
    }
}

// ---------------- UPDATE REVIEW TEXT ----------------
if (isset($_POST['update_review'])) {
    $id = (int) $_POST['id'];
    $name = htmlspecialchars($_POST['name']);
    $position = htmlspecialchars($_POST['position']);
    $note = htmlspecialchars($_POST['note']);
    $status = (int) $_POST['status'];

    $stmt = $pdo->prepare("UPDATE review SET name = ?, position = ?, note = ?, status = ? WHERE id = ?");
    $stmt->execute([$name, $position, $note, $status, $id]);

    echo "<script>
            alert('Review updated successfully!');
            window.location.href = 'reviews.php';
          </script>";
}

// ---------------- UPDATE REVIEW PHOTO ----------------
if (isset($_POST['update_photo'])) {
    $id = (int) $_POST['id'];
    $maxsize = 104857600; // 100MB
    $uploadOk = false;
    $Pack_location = '';

    if (!empty($_FILES["imgfile"]["name"])) {
        $target_dir = "../accounts/upload/review/";
        $filename = basename($_FILES["imgfile"]["name"]);
        $target_file = $target_dir . $filename;
        $extension = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));
        $extensions_arr = ["jpg", "png", "jpeg", "gif", "jfif"];

        if (in_array($extension, $extensions_arr)) {
            if ($_FILES['imgfile']['size'] > 0 && $_FILES['imgfile']['size'] < $maxsize) {
                if (move_uploaded_file($_FILES["imgfile"]["tmp_name"], $target_file)) {
                    $Pack_location = "accounts/upload/review/" . $filename;
                    $uploadOk = true;
                } else {
                    echo "<div class='alert alert-danger'>Failed to upload the file.</div>";
                }
            } else {
                echo "<div class='alert alert-danger'>File too large or empty. Max size is 100MB.</div>";
            }
        } else {
            echo "<div class='alert alert-danger'>Invalid file type.</div>";
        }

        if ($uploadOk) {
            $stmt = $pdo->prepare("UPDATE review SET Pack_location = ? WHERE id = ?");
            $stmt->execute([$Pack_location, $id]);

            echo "<script>
                    alert('Review photo updated successfully!');
                    window.location.href = 'reviews.php';
                  </script>";
        }
    }
}

?>

   



        <div wire:id="0ho7JEz65LVMGIzD4ceZ" wire:initial-data="{&quot;fingerprint&quot;:{&quot;id&quot;:&quot;0ho7JEz65LVMGIzD4ceZ&quot;,&quot;name&quot;:&quot;admin.manage-users&quot;,&quot;locale&quot;:&quot;en&quot;,&quot;path&quot;:&quot;admin\/dashboard\/manageusers&quot;,&quot;method&quot;:&quot;GET&quot;,&quot;v&quot;:&quot;acj&quot;},&quot;effects&quot;:{&quot;listeners&quot;:[],&quot;path&quot;:&quot;https:\/\/xtbtrading.live\/trade\/admin\/dashboard\/manageusers&quot;},&quot;serverMemo&quot;:{&quot;children&quot;:[],&quot;errors&quot;:[],&quot;htmlHash&quot;:&quot;ed570425&quot;,&quot;data&quot;:{&quot;pagenum&quot;:10,&quot;searchvalue&quot;:&quot;&quot;,&quot;orderby&quot;:&quot;id&quot;,&quot;orderdirection&quot;:&quot;desc&quot;,&quot;selectPage&quot;:false,&quot;selectAll&quot;:false,&quot;checkrecord&quot;:[],&quot;selected&quot;:&quot;&quot;,&quot;action&quot;:&quot;Delete&quot;,&quot;username&quot;:null,&quot;fullname&quot;:null,&quot;email&quot;:null,&quot;password&quot;:null,&quot;message&quot;:null,&quot;subject&quot;:null,&quot;plan&quot;:null,&quot;datecreated&quot;:null,&quot;topamount&quot;:null,&quot;toptype&quot;:null,&quot;topcolumn&quot;:&quot;Bonus&quot;,&quot;page&quot;:1,&quot;paginators&quot;:{&quot;page&quot;:1}},&quot;dataMeta&quot;:[],&quot;checksum&quot;:&quot;9e82a6adabccc53607a584c57da8f89b4130352eb62c7aa9cc50f9455ca3c494&quot;}}">
    <div class="main-panel">
        <div class="content bg-light">
            <div class="page-inner">
                <div class="mt-2 mb-4">
                    <h1 class="title1 text-dark">REVIEWERS</h1>
                </div>
                <div>
    </div>                <div>
    </div>                
               
               
               
               
                    <div class="mb-5 row">
                    <div class="col-md-12 ">
                 <!--<div class="card shadow p-4 bg-light">-->
                           
                           
                                                
                  
<?php 
if(isset($success_review)){
    echo $success_review;
}
?>

   
      
            <?php 
if(isset($edit_review)){
    echo $edit_review;
}
?>
    
    
    
     <?php 
if(isset($edit_photo)){
    echo $edit_photo;
}
?>
       
      
                         
                            
                            
                            
                            
                            
                            
                          


        
            
            
            
             
         
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            padding: 0;
            box-sizing: border-box;
        }

        .message {
            background-color: #f0f0f0;
            border-radius: 10px;
            padding: 15px;
            margin-bottom: 10px;
            max-width: 100%;
            word-wrap: break-word;
            position: relative;
        }

        .hidden-text {
            display: none;
        }

        .view-more {
            color: #007bff;
            cursor: pointer;
            font-size: 14px;
        }

        .view-more:hover {
            text-decoration: underline;
        }
    </style>

 <?php
try {
    $stmt = $pdo->query("SELECT * FROM review ORDER BY id ASC");
    $reviews = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    echo "<div class='alert alert-danger'>Error: " . htmlspecialchars($e->getMessage()) . "</div>";
}

if (isset($_GET['del']) && is_numeric($_GET['del'])) {
    echo "<span style='color:red'>Successfully deleted<br><meta http-equiv='refresh' content='2; url=reviews.php'/></span>";
}

foreach ($reviews as $row):
?>
<div class="message">
    <span class="visible-text">
        <div class="form-group">
            <label class="form-control">REVIEWER NAME</label>
            <input type="text" class="form-control bg-light text-dark" value="<?= htmlspecialchars($row['name']) ?>" readonly><br>
        </div>
    </span>

    <span class="hidden-text">
        <!-- Update Info Form -->
        <form method="POST" enctype="multipart/form-data" action="">
            <input type="hidden" name="id" value="<?= $row['id'] ?>">

            <div class="form-group">
                <label class="form-control">REVIEW NAME</label>
                <input type="text" class="form-control bg-light text-dark" name="name" value="<?= htmlspecialchars($row['name']) ?>" required><br>
            </div>

            <div class="form-group">
                <label class="form-control">POSITION</label>
                <input type="text" class="form-control bg-light text-dark" name="position" value="<?= htmlspecialchars($row['position']) ?>" required><br>
            </div>

            <div class="form-group">
                <label class="form-control">NOTE</label>
                <textarea class="form-control bg-light text-dark" name="note" required><?= htmlspecialchars($row['note']) ?></textarea><br>
            </div>

            <div class="form-group">
                <label class="form-control">STATUS</label>
                <select name="status" class="form-control bg-light text-dark" required>
                    <option value="<?= $row['status'] ?>" selected>
                        <?= $row['status'] == 0 ? "REVIEW NOT ACTIVE" : "REVIEW IS ACTIVE" ?>
                    </option>
                    <option value="1">ACTIVATE REVIEW</option>
                    <option value="0">DEACTIVATE REVIEW</option>
                </select>
            </div>

            <div class="button-group small button">
                <a href="reviews.php?del=<?= $row['id'] ?>" class="btn btn-danger">DELETE REVIEW</a>
                <button type="submit" class="btn btn-success" name="update_review">UPDATE INFO</button>
            </div>
        </form>

        <!-- Update Photo Form -->
        <form method="POST" enctype="multipart/form-data" action="">
            <input type="hidden" name="id" value="<?= $row['id'] ?>">
            <div class="form-group">
                <input type="file" name="imgfile" class="form-control bg-light text-dark" accept="image/*" required>
                <label class="form-control">
                    REVIEW PIX 
                    <img src="../<?= htmlspecialchars($row['Pack_location']) ?>" width="40px" height="40px" class="rounded-circle">
                    <button type="submit" class="btn btn-info" name="update_photo">CHANGE</button>
                </label>
            </div>
        </form>
        <hr>
    </span>

    <span class="btn btn-primary" onclick="toggleViewMore(this)">View More</span>
</div>
<?php endforeach; ?>







<script>
    function toggleViewMore(element) {
        const message = element.parentElement;
        const hiddenText = message.querySelector('.hidden-text');
        const visibleText = message.querySelector('.visible-text');

        if (hiddenText.style.display === 'none' || hiddenText.style.display === '') {
            hiddenText.style.display = 'inline';
            visibleText.style.display = 'none';
            element.textContent = 'View Less';
        } else {
            hiddenText.style.display = 'none';
            visibleText.style.display = 'inline';
            element.textContent = 'View More';
        }
    }
</script>

            
            
            
            
            
            
          
   
    
    
    
    
    
      <hr>
      

     
     

    
    
                      
                       <center>ADD MORE REVIEWS</center>
            
           
            
            
            
          <form method='POST'  enctype='multipart/form-data' action=''> 
          
          
          
             <div class='form-group'>
                        <label class='form-control' >REVIEW NAME</label>
              <input type='text' class='form-control bg-light text-dark' name='name' placeholder="" required/><br>
            </div>
             
             
          
              
              
              <div class='form-group'>
                        <label class='form-control' >POSITION</label>
              <input type='text' class='form-control bg-light text-dark' name='position'  placeholder="" required/><br>
              </div>
              
              
              
              
              <div class='form-group'>
                        <label class='form-control' >NOTE</label>
              <textarea type='text' class='form-control bg-light text-dark' name='note'required/></textarea><br>
              </div>
              
              
             
            
            
            <div class='form-group'>
<label  class='form-control'>STATUS</label>
           <select name='status' class='form-control bg-light text-dark' required/>
                <option value=''>SELECT STATUS</option>
                <option value='1'>ACTIVATE</option>
                <option value='0'>DI-ACTIVATE</option>
            </select>
            </div>
            
            
            
           
     
    
    
    <div class='form-group'>
                        <label class='form-control' >UPLOAD REVIEW PIX </label>
             <input type='file' class='form-control bg-light text-dark' name='imgfile2' accept='image/*'  />   
            </div> 
             
     

    <button type="submit" class="btn btn-success btn-block btn-theme-colored2 text-red btn-lg btn-flat" name="add_review">ADD REVIEW</button>

            </form>          
            
            
            
            
            

 
            
        </div></div></div>
<!--=====================================-->

</div>

 <?php
require ("footer.php")
?>

