<?php 
require_once("header.php");

$log_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

// Handle deletion
if (isset($_GET['del'])) {
    $del_id = intval($_GET['del']);

    try {
        $stmt = $pdo->prepare("DELETE FROM deposit WHERE id = ?");
        $stmt->execute([$del_id]);

        // Redirect after deletion
        echo "<script>
            alert('Deleted successfully!!!');
            window.location.href = 'udeposit.php?id=" . $log_id . "';
        </script>";
        exit;
    } catch (PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
}
?>

<div class='main-panel'>
    <div class='content bg-light'>
        <div class='page-inner'>
            <div class='table-responsive'>

<?php
try {
    $stmt = $pdo->prepare("SELECT * FROM deposit WHERE log_id = :log_id");
    $stmt->execute(['log_id' => $log_id]);
    $ordersres = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (count($ordersres) == 0) {
        echo "<strong>No Requests</strong>";
    } else {
        echo "<div class='table-responsive'>
                <table class='table table-bordered'>
                    <thead>
                        <tr>
                            <th>DATE</th>
                            <th>LOGIN ID</th>
                            <th>ENTRY ID</th>
                            <th>USER</th>
                            <th>EMAIL</th>
                            <th>NOTE</th>
                            <th>METHOD</th>
                            <th>AMOUNT</th>
                            <th>TRANSACTION ID</th>
                            <th>STATUS</th>
                            <th>ACTION</th>
                        </tr>
                    </thead>
                    <tbody>";

        foreach ($ordersres as $row) {
            echo "<tr>
                    <td>" . date("D jS F Y g.iA", strtotime($row['date'])) . "</td>
                    <td>" . htmlspecialchars($row['log_id']) . "</td>
                    <td>" . htmlspecialchars($row['id']) . "</td>
                    <td>" . htmlspecialchars($row['user']) . "</td>
                    <td>" . htmlspecialchars($row['email']) . "</td>
                    <td>" . htmlspecialchars($row['note']) . "</td>
                    <td>" . htmlspecialchars($row['method']) . "</td>
                    <td>" . htmlspecialchars($row['amount']) . " " . htmlspecialchars($row['user_cur']) . "</td>
                    <td>" . htmlspecialchars($row['trans_id']) . "</td>";

            switch ($row['status']) {
                case '0': echo "<td class='text-primary'>PENDING</td>"; break;
                case '1': echo "<td class='text-primary'>AWAITING</td>"; break;
                case '2': echo "<td class='text-success'>DEPOSIT CONFIRMED</td>"; break;
                case '3': echo "<td class='text-danger'>DECLINED</td>"; break;
                case '4': echo "<td class='text-danger'>PAUSED</td>"; break;
                default: echo "<td>UNKNOWN STATUS</td>"; break;
            }

            echo "<td>";
            if ($row['status'] != 2) {
                echo "<a href='udeposit_complete.php?id=" . htmlspecialchars($row['id']) . "' class='btn btn-success btn-sm'>CONFIRM DEPOSIT</a>";
            } else {
                $delUrl = "udeposit.php?del=" . htmlspecialchars($row['id']) . "&id=" . htmlspecialchars($log_id);
                echo "<a href='#' class='btn btn-danger btn-sm' onclick=\"confirmDelete('$delUrl'); return false;\">DELETE</a>";
            }
            echo "</td></tr>";
        }

        echo "</tbody></table></div>";
    }
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
}
?>

</div></div></div></div>

<!-- JavaScript: confirm before delete -->
<script>
function confirmDelete(url) {
    if (confirm("Are you sure you want to delete this deposit? This action cannot be undone.")) {
        window.location.href = url;
    }
}
</script>

<?php require("footer.php"); ?>
