<?php
session_start();
require_once("../config.php"); // adjust if needed

if (!isset($_SESSION['SESS_ADMINLOGGEDIN'])) {
    http_response_code(403);
    exit("Unauthorized");
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $setting = $_POST['setting'] ?? '';
    $value   = $_POST['value'] ?? '';

    $allowed = ['service2', 'otp_status', 'main_status', 'service3', 'service4', 'service5', 'end_time'];

    if (in_array($setting, $allowed)) {
        $stmt = $pdo->prepare("UPDATE settings SET $setting = ? ORDER BY id DESC LIMIT 1");
        $stmt->execute([$value]);
        echo "✅ $setting updated to $value";
    } else {
        echo "❌ Invalid setting";
    }
}
?>
