<?php 
require_once("header.php");

$log_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

/* ─────────────────────────────────────────────
   HANDLE DELETE REQUEST
   ───────────────────────────────────────────── */
if (isset($_GET['del'])) {
    $del_id = intval($_GET['del']); // sanitize

    try {
        $stmt = $pdo->prepare("DELETE FROM trade WHERE id = ?");
        $stmt->execute([$del_id]);

        echo "<script>
            alert('Deleted successfully!!!');
            window.location.href = 'utrade.php?id={$log_id}';
        </script>";
        exit;
    } catch (PDOException $e) {
        echo "Error: " . $e->getMessage();
        exit;
    }
}
?>

<div class="main-panel">
  <div class="content bg-light">
    <div class="page-inner">
      <div class="table-responsive">

<?php
try {
    $stmt = $pdo->prepare("SELECT * FROM trade WHERE log_id = :log_id");
    $stmt->execute(['log_id' => $log_id]);
    $ordersres = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (count($ordersres) === 0) {
        echo "<strong>No Requests</strong>";
    } else {
        echo "
        <div class='table-responsive'>
        <table class='table table-bordered'>
        <thead>
            <tr>
                <th>PLAN</th>
                <th>ASSET</th>
                <th>SIGNAL</th>
                <th>EMAIL</th>
                <th>POSITION</th>
                <th>AMOUNT</th>
                <th>RETURNS</th>
                <th>STATUS</th>
                <th>CONFIRM</th>
                <th>ACTION</th>
            </tr>
        </thead>
        <tbody>";

        foreach ($ordersres as $row) {
            $id        = htmlspecialchars($row['id']);
            $amount    = number_format($row['invested'], 2);
            $currency  = htmlspecialchars($row['user_cur']);
            $status    = $row['status'];

            echo "<tr>
                <td>" . htmlspecialchars($row['plan']) . "</td>
                <td>" . htmlspecialchars($row['asset']) . "</td>
                <td>" . htmlspecialchars($row['signa']) . "</td>
                <td>" . htmlspecialchars($row['email']) . "</td>
                <td>{$amount} {$currency}</td>
                <td>" . htmlspecialchars($row['optionr']) . "</td>
                <td>" . htmlspecialchars($row['returnr']) . " {$currency}</td>";

            // Status
            switch ($status) {
                case '0': echo "<td class='text-primary'>TRADING</td>"; break;
                case '1': echo "<td class='text-success'>WIN</td>"; break;
                case '2': echo "<td class='text-danger'>LOSE</td>"; break;
                default:  echo "<td>UNKNOWN</td>"; break;
            }

            // Confirm Trade
            echo "<td>
                <a href='utrade_complete.php?id={$id}' class='btn btn-success btn-sm'>CONFIRM TRADE</a>
            </td>";

            // Delete action
            $delUrl = "utrade.php?del={$id}&id={$log_id}";
            echo "<td>
                <a href='#' onclick=\"confirmDelete('$delUrl'); return false;\" class='btn btn-danger btn-sm'>DELETE</a>
            </td>";

            echo "</tr>";
        }

        echo "</tbody>
        </table>
        </div>";
    }
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
}
?>

      </div>
    </div>
  </div>
</div>

<!-- Confirmation JavaScript -->
<script>
function confirmDelete(url) {
    if (confirm("Are you sure you want to delete this trade? This action cannot be undone.")) {
        window.location.href = url;
    }
}
</script>

<?php require("footer.php"); ?>
