<?php
session_start();
require '../config.php';

if (!isset($_GET['token'])) {
    $_SESSION['error'] = "Invalid password reset link!";
    header("Location: login.php");
    exit();
}

$token = $_GET['token'];

// Check if the token exists and is still valid
$stmt = $pdo->prepare("SELECT id, email, reset_expires FROM logins WHERE reset_token = ?");
$stmt->execute([$token]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$user || strtotime($user['reset_expires']) < time()) {
    $_SESSION['error'] = "Reset link has expired!";
    header("Location: forget_password.php");
    exit();
}

// Handle form submission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $new_password = $_POST['password'];
    $confirm_password = $_POST['confirm_password'];

    if ($new_password !== $confirm_password) {
        $_SESSION['error'] = "Passwords do not match!";
    } elseif (strlen($new_password) < 6) {
        $_SESSION['error'] = "Password must be at least 6 characters!";
    } else {
        // Hash the new password
        $hashed_password = password_hash($new_password, PASSWORD_BCRYPT);

        // Update the password in the database
        $stmt = $pdo->prepare("UPDATE logins SET password = ?, reset_token = NULL, reset_expires = NULL WHERE id = ?");
        $stmt->execute([$hashed_password, $user['id']]);

        $_SESSION['success'] = "Password reset successful! You can now login.";
        header("Location: login.php");
        exit();
    }
}
?>

<?php require("header.php"); ?>


    <!-- Account Section -->
    <section class="account-section position-relative">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-6 col-lg-7 col-md-8">
                    <div class="text-center">
                       <a href="/"><img src="<?php echo $url ?>img/LOGO.png" alt="" class="mb-3 img-fluid auth__logo">
                         <style>
                        #yt-widget .yt-listbox__col {
                            display: block !important; /* display: inline-block; */
                            list-style: none;
                            vertical-align: top;
                            /**/
                            max-width: 90% !important;
                        }
                        .yt-listbox {
                            min-width: 200px !important;
                            max-width: 500px !important;
                            max-height: 500px !important;
                            padding: 10px 10px !important;
                            overflow: auto !important;
                        }
                        #yt-widget.yt-state_bottom .yt-listbox {
                            bottom: unset !important;
                        }
                        .yt-listbox li {
                            display: block !important; 
                        }
                        .yt-servicelink {
                            display: none !important;
                        }
                    </style>
                    
                    
<div id="ytWidget"></div>

<script src="https://translate.yandex.net/website-widget/v1/widget.js?widgetId=ytWidget&pageLang=en&widgetTheme=light&autoMode=true" type="text/javascript"></script>
                       </a> 
                    </div>
<h4 class="text-center">Reset Password</h4>
                   

                <?php
                if (isset($_SESSION['error'])) {
                    echo "<p style='color: red;'>" . $_SESSION['error'] . "</p>";
                    unset($_SESSION['error']);
                }
                if (isset($_SESSION['success'])) {
                    echo "<p style='color: green;'>" . $_SESSION['success'] . "</p>";
                    unset($_SESSION['success']);
                }
                ?>

                <form method="POST" action="">
                    
                    
                    <div class="form-group">
                        <label class="text-success">New Password</label>
                        <input type="password" name="password" class="form-control" required>
                    </div>
                    
                    
                    <div class="form-group">
                        <label class="text-success">Confirm Password</label>
                        <input type="password" name="confirm_password" class="form-control" required>
                    </div>
                    
                    
                    
                    <button type="submit" class="btn btn-primary">Reset Password</button>
                </form>
            </div>
        </div>
    </div>
</section>

<?php require("footer.php"); ?>
