const API_BASE='api';let userId=1;
const supportedCurrencies=['USD','EUR','NGN','GBP','JPY'];
let localCurrency=localStorage.getItem('local_currency')||'USD';
async function init(){setupCurrencySelect();await refreshBalances();setupSwapModal();}
function setupCurrencySelect(){const sel=document.getElementById('currency-select');supportedCurrencies.forEach(c=>{const o=document.createElement('option');o.value=c;o.text=c;sel.appendChild(o)});sel.value=localCurrency;sel.addEventListener('change',async e=>{localCurrency=e.target.value;localStorage.setItem('local_currency',localCurrency);await refreshBalances()});}
async function refreshBalances(){const res=await fetch(`${API_BASE}/get_balances.php?user_id=${userId}`);const data=await res.json();renderWallets(data.wallets);await updateTotals(data.wallets);}
function renderWallets(wallets){const list=document.getElementById('wallet-list');list.innerHTML='';const fromSel=document.getElementById('swap-from');const toSel=document.getElementById('swap-to');if(fromSel)fromSel.innerHTML='';if(toSel)toSel.innerHTML='';wallets.forEach(w=>{const el=document.createElement('div');el.className='wallet-card';el.innerHTML=`<div class='wallet-meta'><div class='wallet-symbol'>${w.symbol}</div><div><div style='font-weight:700'>${w.name}</div><div style='opacity:0.7;font-size:13px'>${w.balance} ${w.symbol}</div></div></div><div style='text-align:right'><div id='fiat-${w.symbol}'>—</div><div style='opacity:0.7;font-size:13px'>USD: <span id='usd-${w.symbol}'>—</span></div></div>`;list.appendChild(el);const o1=document.createElement('option');o1.value=w.symbol;o1.text=`${w.symbol} — ${w.name}`;fromSel.appendChild(o1);const o2=document.createElement('option');o2.value=w.symbol;o2.text=`${w.symbol} — ${w.name}`;toSel.appendChild(o2);});}
async function updateTotals(wallets){const mapping={'BTC':'bitcoin','ETH':'ethereum','USDT':'tether','BNB':'binancecoin'};const ids=wallets.map(w=>mapping[w.symbol]||w.name.toLowerCase()).join(',');const vs=['usd',localCurrency.toLowerCase()].join(',');const priceRes=await fetch(`https://api.coingecko.com/api/v3/simple/price?ids=${ids}&vs_currencies=${vs}`);const priceJson=await priceRes.json();let totalUsd=0;for(const w of wallets){const id=mapping[w.symbol]||w.name.toLowerCase();const usdP=priceJson[id]?.usd||0;const locP=priceJson[id]?.[localCurrency.toLowerCase()]||usdP;const usdVal=usdP*Number(w.balance);totalUsd+=usdVal;document.getElementById(`usd-${w.symbol}`).innerText=usdVal.toFixed(2);document.getElementById(`fiat-${w.symbol}`).innerText=(locP*Number(w.balance)).toFixed(2)+' '+localCurrency;}document.getElementById('total-amount').innerText=totalUsd.toFixed(2)+' USD';document.getElementById('total-fiat').innerText=totalUsd.toFixed(2)+' '+localCurrency;}
function setupSwapModal(){const open=document.getElementById('open-swap');const modal=document.getElementById('swap-modal');const close=document.getElementById('close-swap');open.addEventListener('click',()=>modal.classList.remove('hidden'));close.addEventListener('click',()=>modal.classList.add('hidden'));document.getElementById('do-swap').addEventListener('click',doSwap);}
async function doSwap(){const from=document.getElementById('swap-from').value;const to=document.getElementById('swap-to').value;const amount=document.getElementById('swap-amount').value;const res=await fetch(`${API_BASE}/swap.php`,{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify({user_id:userId,from,to,amount})});const json=await res.json();document.getElementById('swap-result').innerText=json.message||'Done';await refreshBalances();}
window.addEventListener('load',init);